# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# Need to tweak provides/requires filters differently if we have rpm 4.9 onwards
%global rpm49 0

Name:		perl-RRD-Simple
Version:	1.44
Release:	alt2_29
Summary:	Simple interface to create and store data in RRD files
Group:		Development/Other
License:	ASL 2.0
URL:		http://search.cpan.org/dist/RRD-Simple
Source0:	http://search.cpan.org/CPAN/authors/id/N/NI/NICOLAW/RRD-Simple-%{version}.tar.gz
BuildArch:	noarch
# Module Build
BuildRequires:	coreutils
BuildRequires:	findutils
BuildRequires:	perl-devel
BuildRequires:	rpm-build-perl
BuildRequires:	perl(Config.pm)
BuildRequires:	perl(Module/Build.pm)
# Module Runtime
BuildRequires:	perl(Carp.pm)
BuildRequires:	perl(Data/Dumper.pm)
BuildRequires:	perl(Exporter.pm)
BuildRequires:	perl(File/Basename.pm)
BuildRequires:	perl(File/Copy.pm)
BuildRequires:	perl(File/Spec.pm)
BuildRequires:	perl(File/Temp.pm)
BuildRequires:	perl(POSIX.pm)
BuildRequires:	perl(RRDs.pm)
BuildRequires:	perl(strict.pm)
BuildRequires:	perl(vars.pm)
BuildRequires:	perl(warnings.pm)
# Test Suite
BuildRequires:	perl(lib.pm)
BuildRequires:	perl(Test/More.pm)
# Optional Tests
BuildRequires:	perl(Test/Pod.pm)
BuildRequires:	perl(Test/Pod/Coverage.pm)
# Runtime
Requires:	perl(Data/Dumper.pm)
Requires:	perl(File/Copy.pm)
Requires:	perl(File/Temp.pm)

# Optional test dependency that breaks tests
# https://rt.cpan.org/Public/Bug/Display.html?id=46193
BuildConflicts:	perl(Test::Deep)

# Move to unversioned documentation directories from F-20
# https://fedoraproject.org/wiki/Changes/UnversionedDocdirs
%global rrd_docdir %{?_pkgdocdir}%{!?_pkgdocdir:%{_docdir}/%{name}-%{version}}
Source44: import.info

%description
RRD::Simple provides a simple interface to RRDTool's RRDs module. This module
does not currently offer the fetch method that is available in the RRDs
module. It does, however, create RRD files with a sensible set of default RRA
Round Robin Archive) definitions, and can dynamically add new data source
names to an existing RRD file.

This module is ideal for quick and simple storage of data within an RRD file
if you do not need to, nor want to, bother defining custom RRA definitions.

%prep
%setup -q -n RRD-Simple-%{version}

# Don't want provides/requires from documentation
%global docfilt perl -p -e 's|%{rrd_docdir}\\S+||'
# RRD::Simple version should be from distribution version, not svn revision
%global verfilt perl -p -e 's/(perl\\(RRD::Simple\\) =) \\d+/\\1 %{version}/'
# Apply provides/requires filters
%if %{rpm49}
%global provfilt /bin/sh -c "%{docfilt} | %{__perllib_provides} | %{verfilt}"
%global __perllib_provides %{provfilt}
%global reqfilt /bin/sh -c "%{docfilt} | %{__perllib_requires}"
%global __perllib_requires %{reqfilt}
%else
%global provfilt /bin/sh -c "%{docfilt} | %{__perl_provides} | %{verfilt}"
%global __perl_provides %{provfilt}
%global reqfilt /bin/sh -c "%{docfilt} | %{__perl_requires}"
%global __perl_requires %{reqfilt}
%endif

%build
# Prevent call-home query/timeout; not strictly necessary
AUTOMATED_TESTING=1 perl Build.PL --installdirs=vendor
./Build

%install
./Build install --destdir=%{buildroot} --create_packlist=0
# %{_fixperms} %{buildroot}

%check
LC_ALL=C ./Build test

%files
%if 0%{?_licensedir:1}
%doc --no-dereference LICENSE NOTICE
%else
%doc LICENSE NOTICE
%endif
%doc Changes README examples/ t/
%dir %{perl_vendor_privlib}/RRD/
%dir %{perl_vendor_privlib}/RRD/Simple/
%{perl_vendor_privlib}/RRD/Simple.pm
%doc %{perl_vendor_privlib}/RRD/Simple/Examples.pod

%changelog
