# BEGIN SourceDeps(oneline):
BuildRequires: perl(App/pod2pdf.pm) perl(B.pm) perl(CPAN.pm) perl(Carp.pm) perl(Class/Accessor.pm) perl(Config.pm) perl(Cwd.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(FileHandle.pm) perl(FindBin.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Net/LDAP.pm) perl(Net/LDAP/Server/Test.pm) perl(Parse/CPAN/Meta.pm) perl(RT.pm) perl(RT/Config.pm) perl(RT/Handle.pm) perl(RT/System.pm) perl(Scalar/Util.pm) perl(Socket.pm) perl(Test/More.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_name RT-Extension-LDAPImport
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.36
Release: alt1
Summary: Import Users from an LDAP store
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AL/ALEXMV/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
In `RT_SiteConfig.pm':

    Set($LDAPHost,'my.ldap.host')
    Set($LDAPUser,'me');
    Set($LDAPPassword,'mypass');
    Set($LDAPFilter, '(&(cn = users))');
    Set($LDAPMapping, {Name         => 'uid', # required
                       EmailAddress => 'mail',
                       RealName     => 'cn',
                       WorkPhone    => 'telephoneNumber',
                       Organization => 'departmentName'});
    
    # Add to any existing plugins
    Set(@Plugins, qw(RT::Extension::LDAPImport));
    
    # If you want to sync Groups from LDAP into RT
    
    Set($LDAPGroupBase, 'ou=Groups,o=Our Place');
    Set($LDAPGroupFilter, '(&(cn = Groups))');
    Set($LDAPGroupMapping, {Name               => 'cn',
                            Member_Attr        => 'member',
                            Member_Attr_Value  => 'dn' });

Running the import:

    # Run a test import
    /opt/rt4/local/plugins/RT-Extension-LDAPImport/bin/rtldapimport \
    --debug > ldapimport.debug 2>&1
    
    # Run for real, possibly put in cron
    /opt/rt4/local/plugins/RT-Extension-LDAPImport/bin/rtldapimport \
    --import

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/R*

%changelog
