%define module_name RT-Extension-Nagios
# BEGIN SourceDeps(oneline):
BuildRequires: perl(App/pod2pdf.pm) perl(B.pm) perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(FileHandle.pm) perl(FindBin.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(RT.pm) perl(RT/Action.pm) perl(RT/Config.pm) perl(RT/Handle.pm) perl(RT/System.pm) perl(Scalar/Util.pm) perl(Socket.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.01
Release: alt1
Summary: Merge and resolve Nagios tickets
Group: Development/Perl
License: gpl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AL/ALEXMV/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Based on http://wiki.bestpractical.com/view/AutoCloseOnNagiosRecoveryMessages,
thanks, Todd Chapman!

Nagios( http://www.nagios.org ) is a powerful monitoring system that enables
organizations to identify and resolve IT infrastructure problems before they
affect critical business processes.

Once you create Nagios tickets by piping Nagio's email notifications, this
extension helps you merge and resolve them.

We identify email by its subject, so please keep it as the
default one or alike, i.e. subject should pass the regex:

`qr{(PROBLEM|RECOVERY|ACKNOWLEDGEMENT)\s+(Service|Host) Alert: ([^/]+)/?(.*)\s+is\s+(\w+)}i'

e.g.  "PROBLEM Service Alert: localhost/Root Partition is WARNING":

There are 5 useful parts in subject( we call them type, category, host,
problem_type and problem_severity ):

PROBLEM, Service, localhost, Root Partition and WARNING

( Currently, we don't make use of problem_severity actually )

After the new ticket is created, the following is done:

1. find all the other active tickets in the same queue( unless
`RT->Config->Get('NagiosSearchAllQueues')' is true, which will cause
to search all the queues ) with the same values of $category, $host and
$problem_type.

2. if `RT->Config->Get('NagiosMergeTickets')' is true, merge all of
them. if $type is 'RECOVERY', resolve the merged ticket.

if `RT->Config->Get('NagiosMergeTickets')' is false and $type is
'RECOVERY', resolve all them.

NOTE:

config items like `NagiosSearchAllQueues' and `NagiosMergeTickets' can be set
in etc/RT_SiteConfig.pm like this:

    Set($NagiosSearchAllQueues, 1); # true
    Set($NagiosMergeTickets, 0); # false, no merge will be done
    Set($NagiosMergeTickets, 1); # merged to the newest ticket.
    Set($NagiosMergeTickets, -1); # merged to the oldest ticket.

by default, tickets will be resolved with status `resolved', you can
customize this via config item `NagiosResolvedStatus', e.g.

    Set($NagiosResolvedStatus, "recovered");


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/R*

%changelog
