# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Module/Build.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.01
%define module_name Race-Condition
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: Mark and make testable/debuggable known race conditions
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/D/DM/DMUEY/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Often we mark race conditions that are not immediately solvable with a comment:

    if (!-l $config && -f _ && -r _) {
        # RACE! config file could go away, change type, or become unreadable between file test and file read
        open my $fh, '<', $config .eI
        .eI

That is good so that future us can be easily reminded of the issue. It is really hard/impossible to debug or test the various possible race conditions though.

This module gives us a way to still mark the race condition but also adds in the ability to hook into it for debugging or testing purposes.

    if (!-l $config && -f _ && -r _) {
        race::condition('config file could go away, change type, or become unreadable between file test and file read');
        open my $fh, '<', $config .eI
        .eI
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/R*

%changelog
