# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm)
# END SourceDeps(oneline)
%define module_name Random-Skew
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.09
Release: alt1
Summary: Set up a pool of items to return one of, randomly -- with some more likely than others
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TR/TRILLICH/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
For generating random data with a bit of skew to the proportions -- you
first set up a pool of weighted random items to choose from, and then
return one of those items at random. The relative weighting determines
how likely any particular item is returned.

Imagine this monstrous memory hog:

  my @setup = (('Dog') x 76_000_000,
               ('Cat') x 58_000_000,
               ('Parrot') x 500_000,
               ('Octopus') x    125);
  my $pet = $setup[ rand( @setup ) ];

Instead, we do this:

  # Household Pets:
  my $random_pet = Random::Skew->new(
    # item => weight,
    Dog    => 76_000_000,
    Cat    => 58_000_000,
    Parrot =>    500_000,
    Octopus=>        125,
  );
  my $pet = $random_pet->item; # Probably Dog, but could be Octopus

In the above example, "Dog" is waaay more likely to show up than "Octopus"
is. "Cat" is more likely than "Parrot" but less likely than "Dog". The
percentages actually returned during a million-iteration run, might deviate
a bit from the requested weightings, due to rounding, but not by much.

The higher the relative 'weight' the more likely that item will appear
in the result. The lower the relative 'weight' the less likely.

You can also generate a bunch in one go using the items() method:

  my @stuff = $rs->items( 200 );

For reasonably simple hierarchical data, one approach could be to
try complex hash keys:

  my $random_loc = Random::Skew->new(
    'CA:Los Angeles'   =>10000,
    'CA:San Diego'     => 6700,
    'CA:San Francisco' => 4150,
    'NY:New York'      => 8888,
    'NY:Albany'        =>  555,
    'IL:Chicago'       => 8100,
    'IL:Springfield'   =>  321,
  );

  while ( ... ) {
      my $loc = $random_loc->item;
      my ( $st, $city ) = split /:/,$loc;
      #...
  }

Check the examples directory for other ways to generate multi-level
random data.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README examples
%perl_vendor_privlib/R*

%changelog
