# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Random/Skew.pm)
# END SourceDeps(oneline)
%define module_name Random-Skew-Test
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Handy means for testing (and fine tuning) Random::Skew.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TR/TRILLICH/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Tests Random::Skew algorithm and generates printable results.
Can be useful for learning which granularity values
(`$Random::Skew::GRAIN') and what rounding values
(`$Random::Skew::ROUNDING') are best for your uses.

The sample() method takes these parameters:

=over 4

=item iter

    iter => 5_000_000,

This integer is how many iterations to run for the test, where
the section on "$Random::Skew" returns this many weighted-random items.  It's
quite fast, you can do 10_000_000 iterations of many
configurations in just a few seconds.

=item skew

This hashref represents your weighted scale of items to return.
The values in the skew hash represent how likely the keys are to
be returned randomly.

    skew => {
        Ubiquitous => 39_999,
        Mucho      => 1962,
        Sometimes  => 19,
        Unusual   => 4,
    }

=item grain

This arrayref sets the max size (how many buckets) of the sampling
set, which determines how much 'rounding' you might experience.
It runs a separate test for each 'grain'.

    grain => [ qw/24 75 159 890/ ]

The idea is, `$GRAIN' establishes how coarse the buckets are for
your set of items. Example: If you have skew values of 40, 30, 20, 10
you can scale those down with perfect fidelity with a grain of 10
buckets (4 tens, 3 tens, 2 tens, 1 ten is exactly represented,
proportionally, by 4, 3, 2, 1).  If you have `$GRAIN=8' buckets
you'd have these ten items squeezed into 3, 2, 1 with a smaller
subset for the tiny item, whereas with `$GRAIN=13'  buckets
you'd have 5, 3, 2, 1. In these cases some items will be slightly
over-represented and others will be slightly under-represented
due to rounding.

Astonishingly, for `$Random::Skel::GRAIN', small values (13, 28,
41 etc) work amazingly well in many cases, but you could use a
ridiculously high number (2500? 50_000?) if you have the RAM and
want to give it a try. Take it out for a spin.

You can't have a `$GRAIN' less than 2, and 2 won't be too useful
in most cases. You'll likely want to use values 10 or more.
Experiment.

Note t...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/R*

%changelog
