# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Mojolicious.pm) perl(Moo.pm) perl(Pod/Coverage/TrustPod.pm) perl(Reactive/Core.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Type/Tiny.pm) perl(namespace/clean.pm)
# END SourceDeps(oneline)
%define module_name Reactive-Mojo-Plugin
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.103
Release: alt1
Summary: Mojolicious plugin for Reactive
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RM/RMOORE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Register the plugin in startup method of your Mojolicious App

It takes `namespaces` configuration param which should be an arrayref of the namespaces within your app to scan for Reactive components

sub startup ($self) {
    ...
    $self->secrets($config->{secrets});

    $self->plugin(
        'Reactive::Mojo::Plugin',
        {
            namespaces => [
                'My::App::Components',
            ],
        },
    );
    ...

Then within you templates you can use a component like

<%%= reactive('Counter') %%>

or if there is initial state you want to set

<%%= reactive('Counter', value => 10) %%>

add the required JS with
<%%= reactive_js %%>

see Reactive::Core and Reactive::Examples for more information about creating components

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md LICENSE README Changes ignore.txt
%perl_vendor_privlib/R*

%changelog
