# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Readonly.pm) perl(Readonly/Enum.pm) perl(Test/DescribeMe.pm) perl(Test/Most.pm) perl(Test/Needs.pm) perl(Test/NoWarnings.pm)
# END SourceDeps(oneline)
%define module_name Readonly-Values-Months
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: Months Constants
Group: Development/Perl
License: open_source
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/N/NH/NHORNE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use Readonly::Values::Months;

    # Simple month constants
    print "January is month number $JAN\n";    # January is month number 1
    print "December is month number $DEC\n";   # December is month number 12

    # Lookup a month number by name (case-insensitive keys)
    my $num = $months{'april'};     # 4
    print "April => $num\n";

    # Iterate full month names
    for my $name (@month_names) {
        printf "%%-9s => %%2d\n", ucfirst($name), $months{$name};
    }

    # Short names (first three letters)
    print 'Abbreviations: ', join(', ', @short_month_names), "\n";
    # Abbreviations: jan, feb, mar, apr, may, jun, jul, aug, sep, oct, nov, dec

    # Exported symbols:
    #   $JAN ... $DEC
    #   %%months
    #   @month_names
    #   @short_month_names

    print "December is often shortened to $month_names_to_short{december}\n";_# "dec"

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes LICENSE
%perl_vendor_privlib/R*

%changelog
