%define module_name Ref-Util-Rewriter
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Slurper.pm) perl(File/Temp.pm) perl(List/Util.pm) perl(PPI.pm) perl(Pod/Coverage/TrustPod.pm) perl(Safe/Isa.pm) perl(Test/EOL.pm) perl(Test/More.pm) perl(Test/Pod/Coverage.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.100
Release: alt1
Summary: Rewrite your code to use Ref::Util
Group: Development/Perl
License: mit
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/X/XS/XSAWYERX/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Warning: You should take into account that the meaning of
the Ref::Util manpage's functions are subject to change with regards to
blessed objects. This might change the rewriter code in the future
to be smarter. This might also mean this won't necessarily achieve
what you're expecting.

Run it, check the diff, check your code, run your code, then
(maybe) - knowing the risk you take and absolutely no liability on
me, my family, nor my pets - merge it.

This module rewrites Perl code to use the Ref::Util manpage instead of your
regular calls to `ref'. It is much substantially faster and avoids
several mistakes that haunt beginning and advanced Perl developers.

Please review the Ref::Util manpage to fully understand the possible implications
of using it in your case instead of the built-in `ref' function.

The following constructs of code are supported:

=over 4

=item * Simple statement conditions

    ref($foo) eq 'CODE'; # -> is_coderef($foo)
    ref $foo  eq 'CODE'; # -> is_coderef($foo)
    ref $foo;            # -> is_ref($foo)

=item * Compound statement conditions

    if ( ref($foo) eq 'HASH' ) {...} # -> if( is_hashref($foo) ) {...}
    if ( ref $foo  eq 'HASH' ) {...} # -> if( is_hashref($foo) ) {...}
    if ( ref $foo )            {...} # -> if( is_ref($foo) )     {...}

=item * Postfix logical conditions

    ref($foo) eq 'ARRAY' and ... # -> is_arrayref($foo) and ...
    ref($foo) eq 'ARRAY' or  ... # -> is_arrayref($foo) or  ...
    ref($foo)            or  ... # -> is_ref($foo)      or  ...

=back

The following types of references comparisons are recognized:

=over 4

=item * `SCALAR' = `is_scalarref'

=item * `ARRAY' = `is_arrayref'

=item * `HASH' = `is_hashref'

=item * `CODE' = `is_coderef'

=item * `Regexp' = `is_coderef'

=item * `GLOB' = `is_globref'

=item * `IO' = `is_ioref'

=item * `REF' = `is_refref'

=back
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes
%perl_vendor_privlib/R*

%changelog
