%define module_name Regexp-Common-time
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(I18N/Langinfo.pm) perl(Modern/Perl.pm) perl(POSIX.pm) perl(Regexp/Common.pm) perl(Test/More.pm) perl(Time/Normalize.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.16
Release: alt1
Summary: Date and time regexps.
Group: Development/Perl
License: unrestricted
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MA/MANWAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module creates regular expressions that can be used for parsing
dates and times.  See the Regexp::Common manpage for a general description of
how to use this interface.

Parsing dates is a dirty business. Dates are generally specified in
one of three possible orders: year/month/day, month/day/year, or
day/month/year.  Years can be specified with four digits or with two
digits (with assumptions made about the century).  Months can be
specified as one digit, two digits, as a spelled-out name, or as a
three-letter abbreviation.  Day numbers can be one digit or two
digits, with limits depending on the month (and, in the case of
February, even the year).  Also, different people use different
punctuation for separating the various elements.

A human can easily recognize that "October 21, 2005" and "21.10.05"
refer to the same date, but it's tricky to get a program to come to
the same conclusion.  This module attempts to make it possible to do
so, with a minimum of difficulty.

=over 4

=item *

If you know the exact format of the data to be matched, use one of the
specific, piecemeal pattern builders: `tf' or `strftime'.

=item *

If you are parsing RFC-2822 mail headers, use the `mail' pattern.

=item *

If you are parsing informal American dates, use the `american' pattern.

=item *

If there is some variability in your input data, use one of the
fuzzy-matching patterns in the `dmy', `mdy', or `ymd' families.

=item *

If the data are wildly variable, such as raw user input, you should
probably give up and use the Date::Manip manpage or the Date::Parse manpage.

=back

Time values are generally much simpler to parse than date values.
Only one fuzzy pattern is provided, and it should suffice for most
needs.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/R*

%changelog
