%define module_name Regexp-From-String
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Capture/Tiny.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Regexp/Util.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Needs.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.007
Release: alt1
Summary: Convert '/.../' or 'qr(...)' into Regexp object
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Regexp-From-String

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use Regexp::From::String qw(str_to_re);

 my $re1 = str_to_re('foo');       # stays as string 'foo'
 my $re2 = str_to_re('/foo');      # ditto
 my $re3 = str_to_re('/foo/');     # compiled to Regexp object qr(foo)
 my $re4 = str_to_re('qr(foo)i');  # compiled to Regexp object qr(foo)i
 my $re5 = str_to_re('qr(foo[)i'); # dies, invalid regex syntax

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README
%perl_vendor_privlib/R*

%changelog
