# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_version 0.003
%define module_name Regexp-IPv4
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.003
Release: alt1
Summary: Regular expression for IPv4 addresses
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Regexp-IPv4

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
SYNOPSIS

     use Regexp::IPv4 qw($IPv4_re);
    
     $address =~ /^$IPv4_re$/ and print "IPv4 address\n";

DESCRIPTION

    The regex only recognizes the quad-dotted notation of four decimal
    integers, ranging from 0 to 255 each. Other notations like 32-bit
    hexadecimal number (e.g. 0xFF0000) or shortened dotted notation (e.g.
    255.0.0) are not recognized.


%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README
%perl_vendor_privlib/R*

%changelog
