%define module_version 0.03
%define module_name Regexp-Log-Progress
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Module/Build.pm) perl(Regexp/Log.pm) perl(Test/More.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: A set of regex's to parse Progress log files
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/K/KE/KESTEB/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
These modules provide a set of regex's to parse various Progress OpenEdge
log files. As of 10.2B, the default format for a Progress log line is as 
follows:

 [06/10/31@14:07:15.892-0400] P-002702 T-002867 2 4GL DYNOBJECTS message

Where:

 * 06/10/31 - is the date in yy/mm/dd format
 * 14:07:15.892 - is the time in hh:mm:ss.mls
 * 0400 - is the time zone, expressed as the number of hours relative to GMT
 * 002702 - is the process ID
 * 002867 - is the thread ID
 * 2 - is the logging level associated with this log entry
 * 4GL - is the execution environment
 * DYNOBJECTS - is the log entry type
 * message - the rest is the log message

This has been broken down into these named fields:

 datetime pid tid level process facility message

These selectors have been defined to select specific fields:

 %%datetime $pid %%tid %%level %%process %%facility %%message

For the most part each field is space delimited, but of course this "standard"
is violated at will. Especially the datetime field and some "message" fields 
have a message number associated with them. This can be captured with the 
"msgnum" field and the "%%msgnum" selector.

There are five main types of log files. Each follows this standard in some
fashion, to support this, there are five additional modules. One for each log 
file type.

=over 4

=item the Regexp::Log::Progress::Broker manpage

=item the Regexp::Log::Progress::Server manpage

=item the Regexp::Log::Progress::Database manpage

=item the Regexp::Log::Progress::NameServer manpage

=item the Regexp::Log::Progress::AdminServer manpage

=back


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/R*

%changelog
