%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(Module/Build.pm) perl(Test/More.pm) perl(base.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define module_version 0.0.2
%define module_name Regexp-MatchContext
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.0.2
Release: alt1
Summary: Replace (and improve) $MATCH, $PREMATCH, and $POSTMATCH
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/D/DC/DCONWAY/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
The English.pm module provides named aliases for Perl's built-in `$`',
`$&' and `$'' variables: `$PREMATCH', `$MATCH', and `$POSTMATCH'.
Unfortunately, those aliases suffer the same problems as their
originals: they degrade the performance of every single regex in your
program, even if you're only using them to get information about a
single match.

This module also provides `$PREMATCH', `$MATCH', and `$POSTMATCH',
but in a way that only impacts the performance of matches that you
specify. That is, these three variables are only set if the most
recently matched regex contained the special (non-standard) meta-
flag: `(?p)'.

That is:

    use Regexp::MatchContext -vars;

    $str = 'foobarbaz';

    $str =~ /(?p) foo /x;

    # $PREMATCH contains 'foo'
    # $MATCH contains 'bar'
    # $POSTMATCH contains 'baz'

    $str =~ / foo /x;

    # $PREMATCH, $MATCH, and $POSTMATCH all undef

The `(?p)' marker can be placed anywhere within the regex and, except for
setting the three context variables on a successful match, is otherwise
totally ignored.


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/R*

%changelog
