# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Config.pm) perl(Cwd.pm) perl(English.pm) perl(Exporter.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(FileHandle.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Math/Cartesian/Product.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Socket.pm) perl(Test/Kwalitee.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(YAML/Tiny.pm) perl(base.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define module_version 0.03
%define module_name Regexp-NumRange
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: Create Regular Expressions for numeric ranges
Group: Development/Perl
License: gpl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/J/JR/JRIDEOUT/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Regexp::NumRange is a package for generating regular expression strings. These strings can be used in a regular expression to correctly match numeric strings within only a specified range.

Example Usage:

  use Test::More;
  use Regexp::NumRange qw/ rx_max /;

  my $rx = rx_max(255);

  like '100', qr/^$rx$/, '100 is less than 255';
  unlike '256', qr/^$rx$/, '256 is greater tha 255';


%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc CHANGES README LICENSE
%perl_vendor_privlib/R*

%changelog
