%define module_version 0.004
%define module_name Regexp-Result
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Moo.pm) perl(Sub/Name.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.004
Release: alt1
Summary: store information about a regexp match for later retrieval
Group: Development/Perl
License: perl
URL: http://github.com/pdl/Regexp-Result

Source0: http://cpan.org.ua/authors/id/P/PE/PERRETTDL/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
$foo =~ /(a|an|the) (\w+)/;
_my $result = Regexp::Result->new();

_# ...
_# some other code which potentially executes a regular expression

_my $determiner = $result->c(1);
_# i.e. $1 at the time when the object was created

Have you ever wanted to retain information about a regular expression
match, without having to go through the palaver of pulling things out
of `$1', `pos', etc. and assigning them each to temporary variables
until you've decided what to use them as?

Regexp::Result objects, when created, contain as much information about
a match as perl can tell you. This means that you just need to create
one variable and keep it.

Hopefully, your code will be more comprehensible when it looks like
`$result->last_numbered_match_start->[-1]',
instead of `$-[-1]'. The documentation for the punctuation
variables, by the way, is hidden away in `perldoc perlvar'
along with scary things like `^H'. I've copied most of it and/or
rewritten it below.
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/R*

%changelog
