# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(IO/File.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(Time/HiRes.pm)
# END SourceDeps(oneline)
%define module_version 1.00
%define module_name Repl-Loop
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.00
Release: alt1
Summary: - A command interpreter for applications..
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/B/BR/BRANSCHA/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
It is a read-eval-print loop that supports a lisp-like syntax. It is meant as the top-level for.
command line oriented applications or for telnet access into an application (for monitoring, configuration or debuggin). Behind the
screens it is a small lisp interpreter, but the syntax is tweaked so that it is more suited for
top-level commands. Some examples from the file system command library, these commands immitate
the standard directory browsing commands:

    ls recursive=true
    ls files=true dirs=false
    pwd quiet=true
    
Some examples from the math library:

    print (+ 1 2 3)
    print (+ (* 2 3) (* 4 5))
    print (fac 5) 

The repl supports LISP expressions, but the outermost parenthesis for the topmost expression
can be omitted for the convenience of the user so that the commands look like real commands.
But the full power of LISP expressions can be used if necessary especially for formulating subexpressions.
As a result, `ls recursive=true' is equivalent to `(ls recursive=true)'.

Another unconventional concept in the command syntax is the presence of "pairs".
These are syntactical constructs, they look like named parameters and they can be used as such.
Again, this is for the convenience of the user. The difference with other REPL's is that
the left side and the right side of a pair can be full expressions.

The read-eval-print loop understands basic constructs like tests, loops and so on but all real
functionality should be added in command libraries. It is up to the developer to decide
which functionality will be included in the loop. A number of command libraries are included, but
these are not activated by default.

The REPL provides a service to your application, it provides a full blown expression language
that you get for free. The only thing you have to do to create an application is to create
one or more commands that can be glued together using the  REPL commands. The parser will parse lists, pairs and strings
for you (as a developer), it will evaluate subexpressions and will call your commands.

To be honest, the read-eval-print loop is in reality a read-eval loop. You have to do the printing yourself.
It is up to the commands to decide whether the result should be printed or not.
The "ls" command in in the file system library for example returns a list of file names.
The printing can be turned on or off using the 'quiet' option  and the command looks like "ls quiet=true".
The command could be used to provide a list of path names as an input for other commands (that you write).
So you can tap into the power of other commands while writing your own commands. While writing your
application, the trick is to find a set of commands that work well together, that use each others results so that
they can build on each others functionality.

%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/R*

%changelog
