# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 0.03
%define module_name Rest-Client-Builder
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: Base class to build simple object-oriented REST clients
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/A/AL/ALEXKOM/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
package Your::API;
_use base qw(Rest::Client::Builder);
_use JSON;

_sub new {
__my ($class) = @_;

__my $self;
__$self = $class->SUPER::new({
___on_request => sub {
____return $self->request(@_);
___},
__}, 'http://hostname/api');
__return bless($self, $class);
_};

_sub request {
__my ($self, $method, $path, $args) = @_;
__return sprintf("%%s %%s %%s\n", $method, $path, encode_json($args));
_}

_my $api = Your::API->new();
_print $api->resource->get({ value => 1 });
_# output: GET http://hostname/api/resource {"value":1}

_print $api->resource(10)->post({ value => 1 });
_# output: POST http://hostname/api/resource/10 {"value":1}

_print $api->resource(10)->subresource('alfa', 'beta')->state->put({ value => 1 });
_# output: PUT http://hostname/api/resource/10/subresource/alfa/beta/state {"value":1}

_print $api->resource(10)->subresource->alfa('beta')->state->put({ value => 1 });
_# output: PUT http://hostname/api/resource/10/subresource/alfa/beta/state {"value":1}

_print $api->resource(10)->subresource->alfa->beta->state->put({ value => 1 });
_# output: PUT http://hostname/api/resource/10/subresource/alfa/beta/state {"value":1}

_print $api->resource(10)->delete();
_# output: DELETE http://hostname/api/resource/10
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/R*

%changelog
