%define module_version 0.13
%define module_name Rest-HtmlVis
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Encode.pm) perl(File/ShareDir.pm) perl(JSON/XS.pm) perl(Module/Build/Tiny.pm) perl(Plack/Request.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(URI/Escape/XS.pm) perl(YAML/Syck.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.13
Release: alt1
Summary: Rest API visualizer in HTML
Group: Development/Perl
License: perl
URL: https://github.com/vasekd/Rest-HtmlVis

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/V/VA/VASEKD/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Transform perl hash to html.
Each key in perl hash is transormed to the piece of html, js and css which are include in main html.

Example:

_use Rest::HtmlVis;

_my $htmlvis = Rest::HtmlVis->new({
__events => Rest::HtmlVis::Events
_});

_$htmlvis->html({

__events => [
__],

__links => {
___rel => 'root',
___href => /,
___name => Root resource
__}

__form => {
___GET => {
____from => {
_____type => 'time',
_____default => time(),
____}
___},
___POST => {
____DATA => {
_____type => "text"
_____temperature => 25
____},

___}
__}
_});


HtmlVis has default blocks that are show everytime:

=over 4

=item * default.baseurl

Set default prefix for links in html. Default is '/static'

=item * default.base

See the Rest::HtmlVis::Base manpage.

=item * default.content

See the Rest::HtmlVis::Content manpage.

=back

These blocks can be rewrite when the base or content key is set in constructor params.


%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE share/flot/README.md
%perl_vendor_privlib/R*
%perl_vendor_privlib/auto/*

%changelog
