%define module_name RightScale-Query
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/Headers.pm) perl(JSON.pm) perl(LWP/UserAgent.pm) perl(URI.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.201
Release: alt1
Summary: Query RightScale for server instances
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MQ/MQTECH/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Query the RightScale service for information about server instances.  It can be used
to query for other objects, but at this stage it only provides a helper function to find server instances

    use RightScale;

    # Package Globals
    $RightScale::api_url = 'https://us-4.rightscale.com/api';
    $RightScale::internet_proxy = 'http://proxy.example.com';
    $RightScale::internet_proxy_timeout = 30;

    # Get an access token
    my $refresh_token = 'afd983762efabcd9823209cbdefa9819832dcbea';
    my $access_token = rs_get_access_token( $refresh_token );

    # Check whether we can find the instance
    my $instance_id   = $server_data->{'instance_id'};
    my $rs_cloud_id   = $server_data->{'rs_cloud_id'};
    my $rs_account_id   = $server_data->{'rs_account_id'};
    my $instance_details = rs_find_instance(  $instance_id, $rs_cloud_id, $access_token );

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README.md Changes README README.mkdn
%perl_vendor_privlib/R*

%changelog
