%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires(pre): perl(Class/Std.pm) perl(Class/Std/Utils.pm) perl(ExtUtils/MakeMaker.pm) perl(Locale/KeyedText.pm) perl(Parse/RecDescent.pm) perl(Readonly.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(only.pm) perl(version.pm)
# END SourceDeps(oneline)
%define module_version v0.724.0
%define module_name Rosetta
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.724.0
Release: alt1
Summary: Rigorous database portability
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/D/DU/DUNCAND/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
The "Rosetta" DBMS framework is a powerful but elegant system, which makes
it easy to create and use relational databases in a very reliable,
portable, and efficient way.  This "Rosetta" file is the core of the
Rosetta framework and defines a common programmatic interface (API), called
the Rosetta Native Interface (RNI), which applications invoke and which
multiple interchangeable "Engine" back-ends (usually provided by third
parties) implement.  This interface is rigorously defined, such that there
should be no ambiguity when trying to invoke or implement it, and so an
application written to it should behave identically no matter which
conforming "Engine" is in use.

Rosetta incorporates a complete and uncompromising implementation of "The
Third Manifesto" (TTM), a formal proposal by Christopher J. Date and Hugh
Darwen for a solid foundation for data and database management systems
(DBMSs); like Edgar F. Codd's original papers, TTM can be seen as an
abstract blueprint for the design of a DBMS and the language interface to
such a DBMS.  The main web site for TTM is
http://www.thethirdmanifesto.com/, and its authors have also written
several books and papers and taught classes on the subject over the last
35+ years, along with Codd himself (some are listed in the
the Rosetta::SeeAlso manpage documentation file).  Note that the Rosetta
documentation will be focusing mainly on how Rosetta itself works, and will
not spend much time in providing rationales; you can read TTM itself and
various other external documentation for much of that.

The Rosetta Native Interface is defined mainly in terms of a new high-level
programming language named "Rosetta D", which is computationally complete
(and industrial strength) and has fully integrated database functionality;
this language, which satisfies TTM's definition of a "D" language, is
described fully in the the Rosetta::Language manpage documentation file that comes
with this "Rosetta" distribution.

While it is possible that one could write a self-contained application in
Rosetta D and compile that into its own executable, in practice one would
normally just write some components of their application in Rosetta D (as
either named modules or anonymous routines) and write the rest of the
application in their other language(s) of choice.  Assuming the main
application is written in Perl, it is this "Rosetta" file which provides
the glue between your Perl code and your Rosetta D code; "Rosetta"
implements a virtual machine that is embedded in your Perl application and
in which the Rosetta D code runs (it is analagous to the Perl interpreter
itself, which provides a virtual machine in which Perl code runs).

The classes and methods of this "Rosetta" file, together with those of
the Rosetta::Model manpage, define the balance of the Rosetta Native Interface.  A
Rosetta::Interface::DBMS object represents a single active Rosetta virtual
machine; it has a spartan DBI-inspired set of methods which you use to
compile/prepare and/or invoke/execute Rosetta D statements and routines
within the virtual machine, input data to it, and output data from it.

You can create more than one DBMS object at a time, and they are
essentially all isolated from each other, even if more than one uses the
same Engine class to implement it; that is, multiple DBMS objects will not
have references to each other at a level visible in the Rosetta Native
Interface, if at all.  To account for situations where multiple DBMS
objects want to use the same external resources, such as a repository file
on disk, it is expected that the Engines will employ appropriate measures
such as system-managed locks so that resource corruption or application
failure is prevented.  *Also, Rosetta should be thread safe and/or saavy
in the future, but for now it officially is not and you should not share
Rosetta objects between multiple threads, nor have objects in separate
threads try to access the same external resources.*

Rosetta does not use any dialect of SQL in its native API (unlike many
other DBMS products) because SQL is more ambiguous and error-prone to use,
and it is less expressive.  While Rosetta D is very different from SQL, it
is fully capable of modelling anything in the real world accurately, and it
can support a complete SQL emulation layer on top of it, so that your
legacy applications can be migrated to use the Rosetta DBMS with little
trouble.  Likewise, emulation layers for any other programming language can
be supported, such as Tutorial D or XQuery or FoxPro or dBase.

One distinctive feature of a Rosetta DBMS (compared to a typical other
vendor's DBMS) is that data definition statements are structured as
standard data manipulation statements but that the target relation
variables are system catalog relation variables rather than user-defined
relation variables.  In SQL terms, you create or alter tables by adding or
updating their "information schema" records, which in SQL are read-only,
not by using special 'create' or 'alter' statements.

Each Rosetta Engine has the complete freedom to implement the Rosetta DBMS
and Rosetta D however it likes; all Rosetta cares about is that the user
interface and behaviour conform to its preconceptions.

the Rosetta::Engine::Example manpage is the self-contained and pure-Perl reference
implementation of an Engine and is included in the "Rosetta" core
distribution to allow the core to be completely testable on its own.  It is
coded intentionally in a simple fashion so that it is easy to maintain and
and easy for developers to study.  As a result, while it performs correctly
and reliably, it also performs quite slowly; you should only use Example
for testing, development, and study; you should not use it in production.

For production use, there should be a wide variety of third party Engine
modules that become available over time.  One plan which I favor is that
the new (under development) enterprise-strength and Perl implemented
database server named the Genezzo manpage (see also http://www.genezzo.com/) will
evolve to implement the Rosetta DBMS natively, and be *the* back-end which
I recommend above all others for production use.

Most of the other (near term) third party Engines will likely just map
Rosetta's rigorously defined API onto a pre-existing (pseudo) relational
database manager (such as SQLite, PostgreSQL, MySQL, Firebird, Teradata,
Oracle, Sybase, SQL Server, Informix, DB2, OpenBase, FrontBase, etc).
Given this fact, Rosetta's most prominant feature is that it provides a
common API for access to those databases, each of which takes a different
SQL or pseudo-SQL dialect.  An application written to it should easily port
to alternative relational database engines with minimal effort.

This might seem strange to somebody who has not tried to port between
databases before, especially given that the Perl DBI purports to provide
"Database Independence".  However, the level of DBI's provided independence
is *Database Driver Independence*, and not *Database Language
Independence*.  To further demonstrate the difference, it is useful to
compare the DBI and Rosetta.  See the file the Rosetta::Overview manpage
documentation in this distribution for that comparison.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README TODO Changes docs examples
%perl_vendor_privlib/R*

%changelog
