# BEGIN SourceDeps(oneline):
BuildRequires: perl(Benchmark.pm) perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(PadWalker.pm) perl(Sub/Exporter.pm) perl(Test/More.pm) perl(Want.pm)
# END SourceDeps(oneline)
%define module_version 1.2
%define module_name Rubyish-Attribute
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.2
Release: alt1
Summary: ruby-like accessor builder: attr_accessor, attr_writer and attr_reader.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/SH/SHELLING/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
#!/usr/bin/env perl
   
    use 5.010;

    use strict;
    use warnings;

    {
        package Animal;
        
        use Rubyish::Attribute; 
        # import attr_accessor, attr_writer and attr_reader

        BEGIN {
          attr_accessor "name", "color", "type"; 
        }
        # pass a list as the only one parameter
        # invoke it in compile time to avoid using parenthesis when using instance variable as below

        # then create a constructer based on hashref
        sub new {
            $class = shift;
            bless {}, $class;
        }

        sub rename_as {
          my ($self, $new_name) = @_;
          __name__ = $new_name;

          # __name__ is accurately a lvalue subroutine &__name__() which refer to $self->{name}
          # now it looks like a instance variable.
        }

        1;
    }
   
    $dogy = Animal->new()->name("rock")
                  ->color("black")->type("unknown");
    # new Animal with three attribute

    say $dogy->name;  #=> rock
    say $dogy->color; #=> black
    say $dogy->type;  #=> unknown


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README EXAMPLE Changes
%perl_vendor_privlib/R*

%changelog
