# BEGIN SourceDeps(oneline):
BuildRequires: perl(AutoLoader.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(IO/Socket.pm) perl(Net/DNS.pm) perl(Net/Domain.pm) perl(Net/SMTP.pm) perl(Sys/Hostname.pm)
# END SourceDeps(oneline)
%define module_version 1.1
%define module_name SMTP-Server
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.1
Release: alt1
Summary: A native Perl SMTP Server implementation for Perl.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MA/MACGYVER/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
The Net::SMTP::Server module implements an RFC 821 compliant SMTP.server, completely in Perl.  It's extremely extensible, so adding in
things like spam filtering, or more advanced routing and handling
features can be easily handled.  An additional module,
Net::SMTP::Server::Relay has also been implemented as an example of
just one application of this extensibility.  See the pod for more
details on that module.  This extension has been tested on both Unix
and Win32 platforms.

Creating a new server is as trivial as:

  $server = new Net::SMTP::Server($host, $port);

This creates a new SMTP::Server.  Both $host and $port are optional,
and default to the current hostname and the standard SMTP port (25).
However, if you run on a multi-homed machine, you may want to
explicitly specify which interface to bind to.

The server loop should look something like this:

  while($conn = $server->accept()) {
    my $client = new Net::SMTP::Server::Client($conn) ||
	croak("Unable to handle client connection: $!\n");    

    $client->process;
  }

The server will continue to accept connections forever.  Once we have
a connection, we create a new Net::SMTP::Server::Client.  This is a
new client connection that will now be handled.  The reason why
processing doesn't begin here is to allow for any extensibility or
hooks a user may want to add in after we've accepted the client
connection, but before we give the initial welcome message to the
client.  Once we're ready to process an SMTP session, we call
$client->process.  This may HANG while the SMTP transaction takes
place, as the client and server are communicating back and forth (and
if there's a lot of data to transmit, well...).

Once $client->process returns, various fields have been filled in.
Those are:

  $client->{TO}    -- This is an array containing the intended
                      recipients for this message.  There may be
                      multiple recipients for any given message.

  $client->{FROM}  -- This is the sender of the given message.
  $client->{MSG}   -- The actual message data. :)

The SMTP::Server module performs no other processing for the user.
It's meant to give you the building blocks of an extensible SMTP
server implementation.  For example, using the MIME modules, you can
easily process $client->{MSG} to handle MIME attachments, etc.  Or you
could implement ACLs to control who can connect to the server, or what
actions are taken.  Finally, a suggested use that the author himself
uses, is as an SMTP relay.  There are lots of times I need access to
an SMTP server just to send a message, but don't have access to one
for whatever reason (firewalls, permissions, etc).  You can run your
own SMTP server whether under Unix or Win32 environments, and simply
point your favorite mail client to it when sending messages.  See the
Net::SMTP::Server::Relay modules for details on that use.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README
%perl_vendor_privlib/N*
%perl_vendor_privlib/auto/*

%changelog
