%define module_name SQL-Abstract-Complete
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(SQL/Abstract.pm) perl(Storable.pm) perl(Test/EOL.pm) perl(Test/Kwalitee.pm) perl(Test/More.pm) perl(Test/NoTabs.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test/Portability/Files.pm) perl(Test/Synopsis.pm) perl(Test2/V0.pm) perl(strict.pm) perl(vars.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.11
Release: alt1
Summary: Generate complete SQL from Perl data structures
Group: Development/Perl
License: artistic_2
URL: https://github.com/gryphonshafer/SQL-Abstract-Complete

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/G/GR/GRYPHON/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module was inspired by the excellent the SQL::Abstract manpage, from which in
inherits. However, in trying to use the module, I found that what I really
wanted to do was generate complete SELECT statements including joins and group
by clauses. So, I set out to create a more complete abstract SQL generation
module. (To be fair, the SQL::Abstract manpage kept it's first `$table' argument
inflexible for backwards compatibility reasons.)

This module only changes the select() method and adds a small new wrinkle to
new(). Everything else from the SQL::Abstract manpage is inheritted as-is. Consequently,
you should read the the SQL::Abstract manpage documentation before continuing.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc SECURITY.md README LICENSE Changes
%perl_vendor_privlib/S*

%changelog
