%define module_name SQL-Abstract-FromQuery
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CGI.pm) perl(Digest/MD5.pm) perl(List/MoreUtils.pm) perl(Module/Build.pm) perl(Module/Load.pm) perl(Params/Validate.pm) perl(Regexp/Grammars.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(Try/Tiny.pm) perl(UNIVERSAL/DOES.pm) perl(namespace/clean.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.11
Release: alt1
Summary: Translating an HTTP Query into SQL::Abstract structure
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DA/DAMI/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module is intended to help building Web applications with complex
search forms.  It translates user input, as obtained from an HTML
form, into a datastructure suitable as a `%%where' clause for the
the SQL::Abstract manpage module; that module will in turn produce the SQL
statement and bind parameters to query the database.

Search criteria entered by the user can be plain values, lists of
values, comparison operators, etc. So for example if the form filled
by the user looks like this :

   Name   : Smi*              Gender  : M
   Salary : > 4000            Job     : ! programmer, analyst
   Birth  : BETWEEN 01.01.1970 AND 31.12.1990

the module would produce a hashref like

   { Name      => {-like => 'Smi%%'},
     Gender    => 'M',
     Salary    => {'>' => 4000},
     Job       => {-not_in => [qw/programmer analyst/]},
     Birth     => {-between => [qw/1970-01-01 1990-12-31/]},
 }

which, when fed to the SQL::Abstract manpage, would produce SQL more or less
like this

  SELECT * FROM people
  WHERE Name LIKE 'Smi%%'
    AND Gender = 'M'
    AND Salary > 4000
    AND Job NOT IN ('programmer', 'analyst')
    AND Birth BETWEEN 1970-01-01 AND 1990-12-31

Form fields can be associated to "types" that specify the
admissible syntax and may implement security checks.

Note : this module is in beta state. Many features still need
further study; the API and/or behaviour
may change in future releases; the current documentation is incomplete,
so you have to look at the source code to get all details.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/S*

%changelog
