# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Filter/Simple.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    SQL-Abstract-More
%define upstream_version 1.43

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_1

Summary:    Extension of SQL::Abstract with more constructs and more flexible API
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/SQL/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(List/MoreUtils.pm)
BuildRequires: perl(MRO/Compat.pm)
BuildRequires: perl(Module/Build.pm)
BuildRequires: perl(Params/Validate.pm)
BuildRequires: perl(SQL/Abstract/Classic.pm)
BuildRequires: perl(SQL/Abstract/Test.pm)
BuildRequires: perl(Scalar/Util.pm)
BuildRequires: perl(Test/Exception.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(namespace/clean.pm)
BuildRequires: perl(parent.pm)
BuildArch:  noarch
Source44: import.info

%description
Generates SQL from Perl datastructures. This is a subclass of the
SQL::Abstract manpage, fully compatible with the parent class, but it
handles a few additional SQL constructs, and provides a different API with
named parameters instead of positional parameters, so that various SQL
fragments are more easily identified.

This module was designed for the specific needs of the DBIx::DataModel
manpage, but is published as a standalone distribution, because it may
possibly be useful for other needs.

This software is not yet fully stable; future versions may introduce some
minor differences in the calling interface.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
export PERL5LIB="`pwd`"
perl Build.PL --installdirs=vendor --optimize="$RPM_OPT_FLAGS"

./Build

%check
./Build test

%install
./Build install --destdir=%{buildroot}

%files
%doc Changes META.json META.yml  README
%{perl_vendor_privlib}/*

%changelog
