# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(List/Util.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name SQL-Statement-Functions-ArgMinMax
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.002
Release: alt1
Summary: ARGMIN*/ARGMAX* functions
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/SQL-Statement-Functions-ArgMinMax

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This distribution contains several SQL functions to be used with
the SQL::Statement manpage:

 ARGMAXNUM()
 ARGMAXSTR()
 ARGMINNUM()
 ARGMINSTR()

These functions are not aggregate functions. They are added due to the lack of
CASE statement as well as IF function in SQL::Statement. For example, this SQL
statement:

 SELECT CASE WHEN a > b THEN a ELSE b END FROM table

can be expressed with:

 SELECT ARGMAXNUM(a, b) FROM table

To use a function from Perl script:

 require SQL::Statement::Function::ByName::ARGMAXNUM;
 $dbh->do(qq{CREATE FUNCTION ARGMAXNUM NAME "SQL::Statement::Function::ByName::ARGMAXNUM::SQL_FUNCTION_ARGMAXNUM"});

To use a function from the fsql manpage:

 %% fsql -F ARGMAXNUM --add-csv path/to/sometable.csv "SELECT ARGMAXNUM(col1,col2) FROM sometable ..."
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/S*

%changelog
