# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(FileHandle.pm) perl(Module/Build.pm) perl(Test/More.pm) perl(Text/Soundex.pm) perl(Tie/IxHash.pm)
# END SourceDeps(oneline)
%define module_version 0.12
%define module_name SQL-YASP
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.12
Release: alt1
Summary: SQL::YASP - SQL parser and evaluater
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MI/MIKO/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
use SQL::YASP;
 my ($sql, $stmt, $dbrec, $params);

 $sql = <<'(SQL)';
    select 
        -- supports single and multi-line comments
        -- supports "as fieldname" format for select clauses
        first ||| last as fullname

    from members

    where
        /*
        over 100 built in SQL functions and operators
        including most MySQL functions and operators
        */
        ucase(first) ilike 'Joe' and

        -- Perl-like regular expressions
        first =~ m/ (Joe) | (Steve) /ix and

        -- handles quoted strings and escapes in quotes
        last = 'O''Sullivan' and

        -- any level of nested parens
        -- full support for placeholders
        ((rank >= ?) and (rank <= ?))
 (SQL)
 
 
 # get statement object
 $stmt = SQL::YASP::Statement->new($sql);

 # database record: populate this hash from your database
 $dbrec = 
    {
    first=>'Joe',
    last=>'Smith',
    email=>'joe@idocs.com',
    rank=>10,
    };

 # input parameters
 $params = [10, 20];

 # test if this record passes the where clause
 if ($stmt->{'where'}->evalexpr(db_record=>$dbrec, params=>$params)) {
     # get the record as indicated by the select clause
     my $retrec = $stmt->select_fields(db_record=>$dbrec);
     print $retrec->{'fullname'}, "\n";
 }
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes
%perl_vendor_privlib/S*

%changelog
