%define module_version 0.030
%define module_name SSH-Batch
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(Data/Dumper.pm) perl(Exporter.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/HomeDir.pm) perl(File/Path.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(FileHandle.pm) perl(Filter/Util/Call.pm) perl(FindBin.pm) perl(IO/Pty.pm) perl(IPC/Run3.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(MIME/Base64.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Net/OpenSSH.pm) perl(Parse/CPAN/Meta.pm) perl(PerlIO.pm) perl(Scalar/Util.pm) perl(Set/Scalar.pm) perl(Socket.pm) perl(Term/ReadKey.pm) perl(Test/Deep.pm) perl(Text/Diff.pm) perl(Time/HiRes.pm) perl(YAML.pm) perl(YAML/Tiny.pm) perl(inc/Module/Install.pm) perl(overload.pm) perl(threads/shared.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.030
Release: alt1
Summary: Cluster operations based on parallel SSH, set and interval arithmetic
Group: Development/Perl
License: bsd
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/A/AG/AGENT/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
System administration (sysadmin) is also part of my `$work'. Playing with a (big) bunch of  machines without a handy tool is painful. So I refactored some of our old scripts and hence this module.

This is a high-level abstraction over the powerful the Net::OpenSSH manpage module. A bunch of handy scripts are provided to simplify big cluster operations: the fornodes manpage, the atnodes manpage, the tonodes manpage, and the key2nodes manpage.

`SSH::Batch' allows you to name your clusters using variables and interval/set syntax in your ~/.fornodesrc config file (or a different file name specified by the `SSH_BATCH_RC' environment). For instance:

    $ cat ~/.fornodesrc
    A=foo[01-03].com bar.org
    B=bar.org baz[a-b,d,e-g].cn foo02.com
    C={A} * {B}
    D={A} - {B}

where cluster `C' is the intersection set of cluster `A' and `B' while `D' is the sef of machines that are in `A' but not in `B'.

And then you can query machine host list by using `SSH::Batch''s the fornodes manpage script:

   $ fornodes '{C}'
   bar.org foo02.com

   $ fornodes '{D}'
   foo01.com foo03.com

   $ fornodes blah.com '{C} + {D}'
   bar.org blah.com foo01.com foo02.com foo03.com

It's always best practice to put spaces around set operators like `+', `-', `*', and `/', so as to allow these characters (notably the dash `-') in your host names, as in:

  $ fornodes 'foo-bar-[a-d].com - foo-bar-c.com'
  foo-bar-a.com foo-bar-b.com foo-bar-d.com

for the ranges like `[a-z]', there's also an alternative syntax:

   [a..z]

To exclude some discrete values from certain range, you need set subtration:

   foo[1-100].com - foo[32,56].com

or equivalently

   foo[1-31,33-55,57-100].com

the fornodes manpage could be very handy in shell programming. For example, to test the 80 port HTTP service of a cluster `A', simply put

 $ for node in `fornodes '{A}'`; \
     do curl "http://$node:80/blah'; \
   done

Also, other scripts in this module, like the atnodes manpage, the tonodes manpage, and the key2nodes manpage also call fornodes internally so that you can use the cluster spec syntax in those scripts' command line as well.

the atnodes manpage meets the common requirement of running a command on a remote cluster. For example:

  # at the concurrency level of 6:
  atnodes 'ls -lh' '{A} + {B}' my.more.com -c 6

Or upload a local file to the remote cluster:

  tonodes ~/my.tar.gz '{A} / {B}' :/tmp/

or multiple files as well as some directories:

  tonodes -r ~/mydir ~/mydir2/*.so -- foo.com bar.cn :~/

It's also possible to use wildcards in the cluster spec expression, as in

  atnodes 'ls ~' 'api??.*.com'

where the atnodes manpage will match the pattern `api??.*.com' against the "universal set" consisting of those hosts appeared in ~/fornodesrc and those host names apeared before this pattern on the command line (if any). Note that only `?' (match any character) and `*' (match 0 or more characters) are supported here.

There's also a the key2nodes manpage script to push SSH public keys to remote machines ;)

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release

%description scripts
scripts for %module_name


%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc Changes README.md
%perl_vendor_privlib/S*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
