Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-SVG-Graph
Version:        0.04
Release:        alt2_28
Summary:        Visualize your data in Scalable Vector Graphics (SVG) format
License:        Artistic-2.0
URL:            https://metacpan.org/release/SVG-Graph
Source0:        https://cpan.metacpan.org/authors/id/C/CJ/CJFIELDS/SVG-Graph-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(Module/Build.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Run-time
BuildRequires:  perl(base.pm)
BuildRequires:  perl(constant.pm)
BuildRequires:  perl(Data/Dumper.pm)
BuildRequires:  perl(Math/Spline.pm)
BuildRequires:  perl(Statistics/Descriptive.pm)
BuildRequires:  perl(SVG.pm)
BuildRequires:  perl(Tree/DAG_Node.pm)
# Tests
BuildRequires:  perl(File/Find.pm)
BuildRequires:  perl(File/Temp.pm)
BuildRequires:  perl(Test/More.pm)
Requires:       perl(Statistics/Descriptive.pm) >= 2.600
Requires:       perl(SVG.pm) >= 2.270
Requires:       perl(Tree/DAG_Node.pm) >= 1.040

# Filter under-specified dependencies

Source44: import.info
%filter_from_requires /^perl(\(Statistics.Descriptive\|SVG\|Tree.DAG_Node\).pm)/d

%description
SVG::Graph is a suite of perl modules for plotting data. SVG::Graph
currently supports plots of one-, two- and three-dimensional data, as well
as N-ary rooted trees.

%prep
%setup -q -n SVG-Graph-%{version}

# remove all execute bits from eg subdirectory
find eg -type f -exec chmod -x {} 2>/dev/null ';'

%build
/usr/bin/perl Build.PL installdirs=vendor
./Build

%install
./Build install destdir=$RPM_BUILD_ROOT create_packlist=0
# %{_fixperms} $RPM_BUILD_ROOT/*

%check
./Build test

%files
%doc --no-dereference LICENSE
%doc Changes README eg
%{perl_vendor_privlib}/*

%changelog
