%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(File/Copy.pm) perl(File/Find.pm) perl(File/Path.pm) perl(File/Spec.pm) perl(File/Spec/Functions.pm) perl(Getopt/Long.pm) perl(HTML/Entities.pm) perl(Pod/Usage.pm) perl(Test/More.pm) perl(Test/Simple.pm) perl(XML/Twig.pm) perl(fields.pm)
# END SourceDeps(oneline)
%define module_version 0.28
%define module_name SVG-Metadata
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.28
Release: alt1
Summary: Perl module to capture metadata info about an SVG file
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/B/BR/BRYCE/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module provides a way of extracting, browsing and using RDF
metadata embedded in an SVG file.

The SVG spec itself does not provide any particular mechanisms for
handling metadata, but instead relies on embedded, namespaced RDF
sections, as per XML philosophy.  Unfortunately, many SVG tools don't
support the concept of RDF metadata; indeed many don't support the idea
of embedded XML "islands" at all.  Some will even ignore and drop the
rdf data entirely when encountered.

The motivation for this module is twofold.  First, it provides a
mechanism for accessing this metadata from the SVG files.  Second, it
provides a means of validating SVG files to detect if they have the
metadata.

The motivation for this script is primarily for the Open Clip Art
Library (http://www.openclipart.org), as a way of filtering out
submissions that lack metadata from being included in the official
distributions.  A secondary motivation is to serve as a testing tool for
SVG editors like Inkscape (http://www.inkscape.org).

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc COPYING ChangeLog README doc
%perl_vendor_privlib/S*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
