# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Sysadm/Install.pm) perl(Test/More.pm) perl(Text/Glob.pm) perl(autodie.pm)
# END SourceDeps(oneline)
%define module_version 3.17
%define module_name SVNPlus-TagProtect
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 3.17
Release: alt1
Summary: Perl extension for Subversion tag protection
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/J/JP/JPIETRAS/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
THIS SCRIPT IS A hook FOR Subversion AND IS NOT MEANT TO BE RUN FROM
THE COMMAND LINE UNDER NORMAL USAGE.

It would be run from the command line for configuration
testing and configuration debugging. TagProtect provides
immutablity (write once) protection for the /tags directory
of a subversion repository. This is the default protected
directory and everything is configurable.

Subversion requires that this software be invoked with the
name pre-commit.  Installation of this subversion hook is
trivial, simply put pre-commit into the directory named
hooks found under the directory where you have built the
subversion repostitory. Make sure pre-commit is executable
by the owner of the httpd process.

The subversion admistrator - or anyone with write permission
on the subversion installation directory - can change the
configurtion. Below is a complete configuration set with
default values: Debug value and where subversion looks for
programs it needs:

  DEBUG = 0
  SVNPATH = "/usr/bin/svn"
  SVNLOOK = "/usr/bin/svnlook"

The remaining configuration variables comprise an N-Tuple
and this set can be repeated as many times as wanted.

  PROTECTED_PARENT = "/tags"    # a literal path
  PROTECTED_PRJDIRS = "/tags/*" # literal, glob, or blank
  PRJDIR_CREATORS = "*"         # or comma list, or blank
  ARCHIVE_DIRECTORY = "Archive" # directory name

Do not configure directories with trailing slash characters,
if you do they will simply be discarded anyway but to
avoid confusion don't add them. The configuration of the
protected project directories variable, PROTECTED_PRJDIRS,
must start with the exact same path as its associated
protected parent configuration, namely PROTECTED_PARENT. This
is for security. Also for security any instances of /../
(or the like) found in the PROTECTED_PRJDIRS variable will
be discared.

Each TAG_FOLDER value must be unique and two(2) or more of
them cannot be subdirectories of each other. For example:

  PROTECTED_PARENT = "/tags"
  PROTECTED_PARENT = "/tags/foobar"

will not be allowed.
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/S*

%changelog
