%define module_version 0.02
%define module_name SWIFT-Factory-Tag-Tag15
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Provide a generic TAG15 for a SWIFT message.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/B/BI/BIKER/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Tag 15 is used to start different sub-sequences in many SWIFT messages.

This class is generic in the sence that it can be used to provide TAG15A, TAG15B .. TAG15Z,
all depending upon the `SEQUENCE_ID' given in either the constructor or in the `sequence_id()' method.

If the SWIFT message that is going to be built contains more than one TAG15,
it is probably wise to instantiate more than one object of the SWIFT::Factory::Tag::Tag15 class.

Like this:

  use SWIFT::Factory::Tag::Tag15;
  my $tag15A = SWIFT::Factory::Tag::Tag15->new( SEQUENCE_ID=>'A' );
  my $tag15B = SWIFT::Factory::Tag::Tag15->new( SEQUENCE_ID=>'B' );

Or like this:

  use SWIFT::Factory::Tag::Tag15;
  my $tag15A = SWIFT::Factory::Tag::Tag15->new();
  my $tag15B = SWIFT::Factory::Tag::Tag15->new();

  $tag15A->secuence_id('A');
  $tag15B->secuence_id('B');


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/S*

%changelog
