# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(Test/More.pm) perl(warnings/register.pm)
# END SourceDeps(oneline)
%define module_version 1.00
%define module_name Safe-Logs
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.00
Release: alt1
Summary: Perl extension to avoid terminal emulator vulnerabilities
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/L/LU/LUISMUNOZ/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
As shown by the people at Digital Defense, there are a number of
vulnerabilities that can be remotely exploited in the terminal
emulators that are so common today. These vulnerabilities might allow
an attacker to execute arbitrary commands by a number of methods. The
easiest one, illustrated on
http://www.digitaldefense.net/labs/papers/Termulation.txt shows how to
compromise a remote host by sending carefully chosen requests that end
up in log files. It is then a matter of time for an innocent command
such as

    tail -f poisoned.log

To wreak havoc in your system.

You must `use' this module as the last in the list so that it can
override the methods exported from other modules.

This module is a quick solution for this vulnerability. What it does
is very simple: It replaces ocurrences of the ESC character in the
output of any common logging mechanism such as `use warnings',
`warn', `use Carp' and `die'.

It does so by overriding the functions with a safer alternative so
that no code needs to be changed. Hopefully this will be followed by
better solutions from other Perl developers.

Note that in order for this protection to be effective, this module
must be `use'd as the last module (ie, after all the modules it can
override) in order for proper method replacement to occur.

The protection can also be invoked by the `protect' method, which
takes a list of arguments and returns the same list, with all ESC
characters safely replaced. This method is provided so that you can
call it by yourself.

Tipically, you will want to issue an `use Safe::Logs qw(:all)' after
the last module is `use'd in your code, to automatically benefit from
the most common level of protection agains the attacks describen in
the paper.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README
%perl_vendor_privlib/S*

%changelog
