Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# Perform author and release tests
%if 0%{?rhel} >= 10
%bcond_with perl_Scalar_Properties_enables_extra_test
%else
%bcond_without perl_Scalar_Properties_enables_extra_test
%endif

# noarch, but to avoid debug* files interfering with manifest test:
%global debug_package %{nil}

# Similarly for .package_note* files (#2062685)
%undefine _package_note_file

Name:           perl-Scalar-Properties
Version:        1.100860
Release:        alt2_40
Summary:        Run-time properties on scalar variables
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/Scalar-Properties
Source0:        https://cpan.metacpan.org/authors/id/M/MA/MARCEL/Scalar-Properties-%{version}.tar.gz
Patch0:         Scalar-Properties-1.100860-English-is-for-author-tests.patch
Patch3:         Scalar-Properties-1.100860-skip-MYMETA.yml.patch
BuildArch:      noarch
# ===================================================================
# Build requirements
# ===================================================================
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
# ===================================================================
# Module requirements
# ===================================================================
BuildRequires:  perl(overload.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# ===================================================================
# Test requirements
# ===================================================================
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(File/Temp.pm)
BuildRequires:  perl(Scalar/Util.pm)
BuildRequires:  perl(Test/More.pm)
%if %{with perl_Scalar_Properties_enables_extra_test}
# ===================================================================
# Author test requirements
# (skipped as the Critic test fails in version 1.100860)
# ===================================================================
BuildRequires:  perl(English.pm)
BuildConflicts: perl(Test::Perl::Critic)
# ===================================================================
# Release test requirements
# (Spelling check can't find "versa" in version 1.100860)
# ===================================================================
BuildRequires:  perl(Pod/Coverage/TrustPod.pm)
BuildConflicts: perl(Pod::Wordlist::hanekomu)
BuildRequires:  perl(Test/CheckChanges.pm)
BuildRequires:  perl(Test/CPAN/Meta.pm)
BuildRequires:  perl(Test/DistManifest.pm)
BuildRequires:  perl(Test/HasVersion.pm)
BuildRequires:  perl(Test/Kwalitee.pm)
BuildRequires:  perl(Test/MinimumVersion.pm)
BuildRequires:  perl(Test/Pod.pm)
BuildRequires:  perl(Test/Pod/Coverage.pm)
BuildRequires:  perl(Test/Portability/Files.pm)
BuildRequires:  perl(Test/Synopsis.pm)
%endif
Source44: import.info
# ===================================================================
# Runtime dependencies
# ===================================================================
# (none)

%description
Scalar::Properties attempts to make Perl more object-oriented by taking an idea
from Ruby: Everything you manipulate is an object, and the results of those
manipulations are objects themselves.

%prep
%setup -q -n Scalar-Properties-%{version}

# Delist English from run-time dependencies, otherise t/000-report-versions.t
# may fail if build without extra tests, CPAN RT#134158
%patch0  -p1

# MANIFEST.SKIP should include MYMETA.yml; otherwise, t/release-dist-manifest.t
# may fail due to it appearing unexpectedly
%patch3  -p1

%build
perl Makefile.PL INSTALLDIRS=vendor
%make_build

%install
make pure_install DESTDIR=%{buildroot}
find %{buildroot} -type f -name .packlist -delete
# %{_fixperms} -c %{buildroot}

%check
%if %{with perl_Scalar_Properties_enables_extra_test}
make test AUTHOR_TESTING=1 RELEASE_TESTING=1
%else
make test
%endif

%files
%doc --no-dereference LICENSE
%doc Changes README
%{perl_vendor_privlib}/Scalar/

%changelog
