Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Test/Deep.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Schedule-Cron-Events
Version:        1.96
Release:        alt2_16
Summary:        Take a line from a crontab and find out when events will occur
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/Schedule-Cron-Events
# http://www.cpan.org/modules/by-module/Schedule/Schedule-Cron-Events-%%{version}.tar.gz
# is the original upstream source. Unfortunately Schedule-Cron-Events includes the file
# cron_event_predict.plx - being not covered by any of the license statements inside of
# the upstream tarball. And per Fedora Legal, we have to remove this file once upstream
# has clarified the licensing of this file. Cleaning sources can be simply done using:
#   tar zxvf Schedule-Cron-Events-<version>.tar.gz
#   rm Schedule-Cron-Events-<version>/cron_event_predict.plx
#   comment out some lines in Schedule-Cron-Events-1.93/Makefile.PL
#   tar cvfz Schedule-Cron-Events-<version>-noplx.tar.gz Schedule-Cron-Events-<version>
Source0:        Schedule-Cron-Events-%{version}-noplx.tar.gz
BuildRequires:  coreutils
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
%if 0%{?rhel} && 0%{?rhel} <= 7
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  findutils
%else
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
%endif
# Run-time
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(Set/Crontab.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(Time/Local.pm)
BuildRequires:  perl(warnings.pm)
# Tests
BuildRequires:  perl(Data/Dumper.pm)
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(lib.pm)
BuildRequires:  perl(Test.pm)
BuildRequires:  perl(Test/More.pm)
BuildArch:      noarch
Source44: import.info

%description
Given a line from a crontab, tells you the time at which cron will next run
the line, or when the last event occurred, relative to any date you choose.
The object keeps that reference date internally, and updates it when you
call nextEvent() or previousEvent() - such that successive calls will give
you a sequence of events going forward, or backwards, in time.

%prep
%setup -q -n Schedule-Cron-Events-%{version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build}

%install
%{makeinstall_std}

%if 0%{?rhel} && 0%{?rhel} <= 7
find $RPM_BUILD_ROOT \( -name perllocal.pod -o -name .packlist \) -delete
find $RPM_BUILD_ROOT -depth -type d -exec rmdir {} 2>/dev/null \;
%endif

# %{_fixperms} $RPM_BUILD_ROOT/*

%check
make test

%files
%doc README
%{perl_vendor_privlib}/*

%changelog
