# BEGIN SourceDeps(oneline):
BuildRequires: perl(JSON/XS.pm) perl(Module/Build/Tiny.pm) perl(Pod/Usage.pm) perl(Test/Warn.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define module_name Schedule-Easing
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1.3
Release: alt1
Summary: Stateless, stable filtering of events with ramp-up activation on a schedule
Group: Development/Perl
License: see LICENSE
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BB/BBLACKM/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Easing provides stateless, stable selection of point-in-time events that need to be exposed with increasing frequency over a period of time.  Events may be infrequent or real-time, low or high volume, but must contain some manner of identification for categorization, such as a reported line number or non-random content that can be used to compute a message digest.  As time increases, the percentage of events emitted will be monotonically increasing.

Contrasted with throttling, which suppresses *any* incoming events in real-time once a threshold is exceeded, easing ensures that new events are uniformly distributed over the configured period of time.  Whereas throttling requires cached statistics, easing can be performed without resident processes or data stores.

As an example, easing permits an alerting system to be configured based on a large number of reported failures *that already exist*, without a sudden shift from "no alerts" to a large number of unmanageable alerts.  Easing can also be leveraged in A-to-B activation scenarios, supporting staged deployments or similar.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc TODO.pod README.txt LICENSE Changes
%perl_vendor_privlib/S*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
