%def_without test
# BEGIN SourceDeps(oneline):
BuildRequires: perl(AutoLoader.pm) perl(Config.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Filesys/DfPortable.pm) perl(FindBin.pm) perl(IO/File.pm) perl(IO/Pipe.pm) perl(IO/Poll.pm) perl(IO/Select.pm) perl(IO/Socket.pm) perl(IPC/PidStat.pm) perl(Net/hostent.pm) perl(Pod/Usage.pm) perl(Proc/ProcessTable.pm) perl(Safe.pm) perl(Socket.pm) perl(Storable.pm) perl(Sys/Hostname.pm) perl(Sys/Syslog.pm) perl(Term/ReadLine.pm) perl(Test.pm) perl(Tie/RefHash.pm) perl(Time/HiRes.pm) perl(Time/localtime.pm) perl(Unix/Processors.pm)
# END SourceDeps(oneline)
%define module_version 3.064
%define module_name Schedule-Load
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 3.064
Release: alt1
Summary: Load distribution and status across multiple host machines
Group: Development/Perl
License: perl
URL: http://www.veripool.org/schedule-load

Source0: http://cpan.org.ua/authors/id/W/WS/WSNYDER/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This package provides useful utilities for load distribution and status
across multiple machines in a network.  To just see what is up in the
network, see the the rschedule manpage command.  For initial setup, see below.

Most users do not need the Perl API, and can use the command line utilities
that come with this package, and are installed in your standard binary
directory like other unix applications.  This package provides these four
Unix programs:

=over 4

=item rschedule

the rschedule manpage is a command line interface to this package.  It and the
potential aliases the rtop manpage, the rhosts manpage, and the rloads manpage report the current
state of the network including hosts and top loading.  the rschedule manpage also
allows reserving hosts and setting the classes of the machines, as
described later.

=item slchoosed

the slchoosed manpage is run on one host in the network.  This host is specified in
the SLCHOOSED_HOST environment variable, which may also specify additional
cold standby hosts in case the first host goes down.  Slchoosed collects
connections from the the slreportd manpage reporters, and maintains a internal
database of the entire network.  User clients also connect to the chooser,
which then gets updated information from the reporters, and returns the
information to the user client.  As the chooser has the entire network
state, it can also choose the best host across all CPUs in the network.

=item slreportd

the slreportd manpage must be running on every host in the network, usually started
with a init.d script.  It reports itself to the the slchoosed manpage daemon
periodically, and is responsible for checking loading and top processes
specific to the host that it runs on.

the slreportd manpage may also be invoked with some variables set.  This allows
static host information, such as class settings to be passed to
applications.

=item slpolice

the slpolice manpage is a optional client daemon which is run as a the cron manpage job.
When a user process has over a hour of CPU time, it the nice manpages that process
and sends mail to the user.  It is intended as a example which can be used
directly or changed to suit the system manager preferences.

=item lockerd

the lockerd manpage is part of the the IPC::PidStat manpage package.  If running, it allows
the scheduler to automatically cancel held resources if the process that
requested the resource exits or is even killed without cleaning up.

=back

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc README COPYING readme.texi Changes
%perl_vendor_privlib/S*
%perl_vendor_privlib/auto/*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
