# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define	upstream_name	 Schedule-RateLimiter
%define upstream_version 0.01

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt2_11

Summary:    Prevent events from happening too quickly
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/authors/id/D/DW/DWRIGHT/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Time/HiRes.pm)
BuildArch:  noarch
Source44: import.info

%description
Schedule::RateLimiter provides a way to voluntarily restrict how many times a given
action may take place within a specified time frame.  Such a tool may be useful
if you have written something which periodically polls some public resource and
want to ensure that you do not overburden that resource with too many requests.

Initially, one might think that solving this problem would be as simple as
sleeping for the number of seconds divided by the number of iterations in
between each event.  However, that would only be correct if the event took no
time at all.

If you know exactly how much time each event is going to take then you could
build an even more complicated one-liner such as this:

  sleep( (seconds / iterations) - single_event_time )

This module is intended to address the other cases when the exact run-time of
each event is unknown and variable.  This module will try very hard to allow an
event to happen as many times as possible without exceeding the specified
bounds.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor -d
%make_build

%check
%make_build test

%install
%makeinstall_std

%files 
%doc Changes  README
%{perl_vendor_privlib}/Schedule/RateLimiter.pm


%changelog
