%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Archive/Zip.pm) perl(Benchmark.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(File/Log.pm) perl(Moose.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.02
%define module_name ScriptUtil
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Object Orientated class to make typical command line scripts easier to write
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/C/CA/CAMSTUART/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
ScriptUtil is a class to make typical command line scripts easier to write.

The aim of this module is to reduce the amount of copy & paste and repeated 'scaffolding code' at the top of your scripts.

As time goes by I intend to add more methods for common operations, if you have some suggestions feel free to drop me a line.


Common operations such as:

=over 4

=item * log file initialization (*File::Log*)

=item * log file rotation

=item * locking (so only one instance of your scripts runs at a time)

=item * benchmarking performance (*Benchmark*)

=item * cleaning white space out of strings

=back

Will be taken care of for you when you instantiate a new *ScriptUtil* object.

You can override some or all of the defaults, or leave them as is, see the examples section for more information


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/S*

%changelog
