%define module_version 0.01
%define module_name Se-PersonNr
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: Module for validating and generating a Swedish personnummer.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/E/EB/EBOSRUP/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Se::PersonNr is a module that is used to validate a Swedish personnummer. A personnummer is a
unique number generated by the government for each indivual in Sweden. They are also used as
registration numbers for corporations and other business entities.

A personnummer consists of six digits representing date of birth follow by three serial number
digits and a checksum digit. The date of birth and serial number is split by a plus or minus sign.
(The minus sign is replaced by a plus sign when he or she turn 100.) The date part is two digits
for the year followed by two for the month and another two for the day of month.

Example: A man born on the 13th of October 1951 with serial number 381 gets the personnummer
511013-3815.

The module will accept personnummer in the formats yymmdd-sssc, yymmddsssc, yyyymmdd-sssc
and yyyymmddsssc but only return the first format. The first format may also use the plus sign.

More information about personnummer can be found at: http://www.rsv.se/pdf/70407.pdf (it's
in Swedish).




%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes
%perl_vendor_privlib/S*

%changelog
