# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Test/Kwalitee.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Search-Binary
%define upstream_version 0.99

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_6

Summary:    Generic binary search
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Search/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Carp.pm)
BuildRequires: perl(Exporter.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Test/Warnings.pm)
BuildRequires: perl(lib.pm)
BuildRequires: perl(parent.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(warnings.pm)
BuildArch:  noarch
Source44: import.info

%description
'binary_search' implements a generic binary search algorithm returning the
_position_ of the first _record_ whose _index value_ is greater than or
equal to '$val'. The search routine does not define any of the terms
_position_, _record_ or _index value_, but leaves their interpretation and
implementation to the user supplied function '&$read()'. The only
restriction is that positions must be integer scalars.

During the search the read function will be called with three arguments:
the input parameters '$handle' and '$val', and a position. If the position
is not 'undef', the read function should read the first whole record
starting at or after the position; otherwise, the read function should read
the record immediately following the last record it read. The search
algorithm will guarantee that the first call to the read function will not
be with a position of 'undef'. The read function needs to return a two
element array consisting of the result of comparing '$val' with the index
value of the read record and the position of the read record. The
comparison value must be positive if '$val' is strictly greater than the
index value of the read record, '0' if equal, and negative if strictly
less. Furthermore, the returned position value must be greater than or
equal to the position the read function was called with.

The input parameters '$min' and '$max' are positions and represents the
extent of the search. Only records which begin at positions within this
range (inclusive) will be searched. Moreover, '$min' must be the starting
position of a record. If present '$size' is a difference between positions
and determines when the algorithms switches to a sequential search. '$val'
is an index value. The value of '$handle' is of no consequence to the
binary search algorithm; it is merely passed as a convenience to the read
function.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes LICENSE META.json META.yml  README
%perl_vendor_privlib/*

%changelog
