# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Search-QueryParser
%define upstream_version 0.95

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_2

Summary:    Parses a query string into a data structure
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Search/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Module/Build.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(constant.pm)
BuildArch:  noarch
Source44: import.info

%description
This module parses a query string into a data structure to be handled by
external search engines. For examples of such engines, see the
File::Tabular manpage and the Search::Indexer manpage.

The query string can contain simple terms, "exact phrases", field names and
comparison operators, '+/-' prefixes, parentheses, and boolean connectors.

The parser can be parameterized by regular expressions for specific notions
of "term", "field name" or "operator" ; see the the new manpage method. The
parser has no support for lemmatization or other term transformations :
these should be done externally, before passing the query data structure to
the search engine.

%prep
%setup -q -n %{upstream_name}-%{upstream_version} 

%build
/usr/bin/perl Build.PL --installdirs=vendor
./Build CFLAGS="%{optflags}"

%check
./Build test

%install
./Build install --destdir=%{buildroot}

%files
%doc Changes META.json META.yml  README
%perl_vendor_privlib/*


%changelog
