Epoch: 2
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Pod/Coverage/TrustPod.pm) perl(Test/CPAN/Meta.pm) perl(Test/CPAN/Meta/JSON.pm) perl(Test/EOL.pm) perl(Test/Kwalitee.pm) perl(Test/MinimumVersion.pm) perl(Test/Mojibake.pm) perl(Test/NoTabs.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test/Synopsis.pm) perl(Test/Version.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Selenium-Remote-Driver
%define upstream_version 1.49

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_1

Summary:    Representation of an HTML Element used by Selenium Remote Driver
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/authors/id/T/TE/TEODESIAN/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Archive/Zip.pm)
BuildRequires: perl(Carp.pm)
BuildRequires: perl(Clone.pm)
BuildRequires: perl(Cwd.pm)
BuildRequires: perl(Data/Dumper.pm)
BuildRequires: perl(Exporter.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(File/Basename.pm)
BuildRequires: perl(File/Copy.pm)
BuildRequires: perl(File/Spec.pm)
BuildRequires: perl(File/Spec/Functions.pm)
BuildRequires: perl(File/Temp.pm)
BuildRequires: perl(File/Which.pm)
BuildRequires: perl(File/stat.pm)
BuildRequires: perl(FindBin.pm)
BuildRequires: perl(HTTP/Headers.pm)
BuildRequires: perl(HTTP/Request.pm)
BuildRequires: perl(HTTP/Response.pm)
BuildRequires: perl(IO/Handle.pm)
BuildRequires: perl(IO/Socket.pm)
BuildRequires: perl(IO/Socket/INET.pm)
BuildRequires: perl(IO/String.pm)
BuildRequires: perl(IO/Uncompress/Unzip.pm)
BuildRequires: perl(IPC/Open3.pm)
BuildRequires: perl(JSON.pm)
BuildRequires: perl(LWP/UserAgent.pm)
BuildRequires: perl(List/Util.pm)
BuildRequires: perl(MIME/Base64.pm)
BuildRequires: perl(Moo.pm)
BuildRequires: perl(Moo/Role.pm)
BuildRequires: perl(Scalar/Util.pm)
BuildRequires: perl(Sub/Install.pm)
BuildRequires: perl(Test/Builder.pm)
BuildRequires: perl(Test/Builder/Tester.pm)
BuildRequires: perl(Test/Deep.pm)
BuildRequires: perl(Test/Fatal.pm)
BuildRequires: perl(Test/LWP/UserAgent.pm)
BuildRequires: perl(Test/LongString.pm)
BuildRequires: perl(Test/MockModule.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Time/HiRes.pm)
BuildRequires: perl(Try/Tiny.pm)
BuildRequires: perl(XML/Simple.pm)
BuildRequires: perl(base.pm)
BuildRequires: perl(constant.pm)
BuildRequires: perl(lib.pm)
BuildRequires: perl(namespace/clean.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(warnings.pm)
BuildArch:  noarch
Source44: import.info

%description
Selenium is a test tool that allows you to write automated web application
UI tests in any programming language against any HTTP website using any
mainstream JavaScript-enabled browser. This module is an implementation of
the client for the Remote driver that Selenium provides. You can find
bindings for other languages at this location:

the https://code.google.com/p/selenium/ manpage

This module sends commands directly to the Server using HTTP. Using this
module together with the Selenium Server, you can automatically control any
supported browser. To use this module, you need to have already downloaded
and started the Selenium Server (Selenium Server is a Java application).

%prep
%setup -q -n %{upstream_name}-%{upstream_version}
sed -i 's,#!/bin/env perl,#!/usr/bin/perl,' driver-example.pl

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes LICENSE META.json META.yml  README TAGS
%{perl_vendor_privlib}/*

%changelog
