Epoch: 1
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Data/Dump/Filtered.pm) perl(Data/Dump/Streamer.pm) perl(YAML.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Shell-Perl
%define upstream_version 0.004

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_4

Summary:    Dumpers for Shell::Perl
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Shell/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Class/Accessor.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(File/Basename.pm)
BuildRequires: perl(File/HomeDir.pm)
BuildRequires: perl(File/Slurp.pm)
BuildRequires: perl(Getopt/Long.pm)
BuildRequires: perl(IPC/Cmd.pm)
BuildRequires: perl(Path/Class.pm)
BuildRequires: perl(Term/ReadLine.pm)
BuildRequires: perl(Test/Deep.pm)
BuildRequires: perl(Test/More.pm)
BuildArch:  noarch
Source44: import.info

%description
This is the implementation of a command-line interpreter for Perl. I wrote
this because I was tired of using B<irb> when needing a calculator with a
real language within. Ah, that and because it was damn easy to write it.

This module is the heart of the B<pirl> script provided with B<Shell-Perl>
distribution, along with this module.

EXAMPLE SESSION
        $ pirl
        Welcome to the Perl shell. Type ':help' for more information
    
    
        pirl @> 1+1
        2
    
        pirl @> use YAML qw(Load Dump);
        ()
    
        pirl @> $data = Load("--- { a: 1, b: [ 1, 2, 3] }\n");
        { a => 1, b => [1, 2, 3] }
    
        pirl @> $var = 'a 1 2 3'; $var =~ /(\w+) (\d+) (\d+)/
        ("a", 1, 2)
    
        pirl @> :q

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes META.json META.yml  README
%{perl_vendor_privlib}/*
/usr/bin/pirl
%{_mandir}/man1/pirl.1*

%changelog
