# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(Exporter.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Slurp.pm) perl(File/Spec.pm) perl(FileHandle.pm) perl(IPC/Run3.pm) perl(LWP/Simple.pm) perl(List/Util.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Regexp/Common.pm) perl(Socket.pm) perl(Test/Base.pm) perl(Test/More.pm) perl(YAML.pm) perl(base.pm) perl(inc/Module/Install.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define module_version 0.03
%define module_name Sim
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: Simulator engine for discrete events
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/A/AG/AGENT/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Sim is a general-purpose discrete event simulator engine written in pure
Perl. It was originally developed as the run-core of a sequential/conbinational
logic circuit simulator named Tesla.

The Sim class is just a static class wrapping around a the Sim::Dispatcher manpage
instance and a the Sim::Clock manpage instance. I used AUTOLOAD to do the magic instead
of writing a lot of boring code. It's expected that using the Sim::Dispatcher manpage
directly can be a bit faster but is certainly less convenient.

If you want to use a different clock model with vectorized time read,
say a [sec, delta], which is found in a lot of EDA simulators, then you
should use the Sim::Dispatcher manpage instead of the Sim manpage and define your clock class
yourself.

See the Sim::Dispatcher manpage for more information.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/S*

%changelog
