# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm)
# END SourceDeps(oneline)
%define module_name SlideMap
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.4
Release: alt1
Summary: Perl module for the creation of MicroArray slide maps
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JW/JWHITE/%{module_name}/SlideMap-%{version}.tar.gz
BuildArch: noarch

%description
SlideMap is used to create a row/col -> plate/well map of a microarray 
slide.  It does not as yet incorporate annotation data into the map, 
but simply creates the map object based on input parameters.  The map 
is an ordered list of spots with references to annonymous arrays 
containing array_row, array_col, plate_alias, well.  SlideMap currently 
supports 5 types of arrayers: IAS (default), MD, MD3, Lucidia, and 
Stanford.  (Others will be implemented as needed.)  

SlideMap provides 2 methods for conversion of spots->wells and vise-versa,
based on instantiated parameters.  

The main parameters are: 
machine: _the type of array printing machine used (IAS is the default)
x_pin: __the number of print head pens in the 'X' (plate_row) dimension
y_pin: __the number of print head pens in the 'Y' (plate_col) dimension
___(x_pin = 2, and y_pin = 6 are the defaults)
x_spacing: _the number of spots in one row of a block on the array
y_spacing: _the number of spots in one column of a block on the array
___(x_spacing = 24, and y_spacing = 25 are the defaults)
x_repeat:_the number of repeated block in the 'X' dimension (default = 1)
y_repeat:_the number of repeated block in the 'Y' dimension (default = 1)

The SlideMap module can be used in several ways:
a) 'use' SlideMap, call the constructor with all parameters, and convert 
_spots or wells, fill the map object and loop over it:
_
_use SlideMap;
_$sm->SlideMap->new( machine => "MD3", x_pin => 1, y_pin => 12,
____xspacing => 32, yspacing => 10);
_$ref = $sm->fill_map;
_foreach $row_ref (@$ref)) {
__($row,$col,$plate,$well) = @$row_ref;
__...
_}

b) 'use' SlideMap, call the constructor with minimal parameters, and set 
_parameters individually, then re-initialize and loop over the map:

_use SlideMap;
_$sm->SlideMap->new( machine => "MD3");
_$sm->setBlockDimensions(32,6);
_$ref = $sm->fill_map;
_foreach $row_ref (@$ref)) {
__($row,$col,$plate,$well) = @$row_ref;
__...
_}

c) 'use' SlideMap, call the constructor with machine argument not 
_listed above, set paramet...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc slidemap_documentation.txt Changes README.txt Artistic_License.txt
%perl_vendor_privlib/S*

%changelog
