# BEGIN SourceDeps(oneline):
BuildRequires: perl(Compress/Raw/Lzma.pm) perl(Encode.pm) perl(ExtUtils/MakeMaker.pm)
# END SourceDeps(oneline)
%define module_name Slob
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001
Release: alt1
Summary: Read .slob dictionaries (as used by Aard 2)
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MG/MGV/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Slob is a compressed read-only format for storing natural language
dictionaries. It is used in Aard 2. `Slob.pm' is a module that reads
dictionaries in slob format.

The following methods are available:

=over

=item Slob->new(*$path*)
=item Slob->new(*$fh*)

Create a new slob reader reading from the given path or filehandle.

=item $slob->ref_count

The number of refs (keys) in the dictionary.

=item $slob->seek_and_read_ref(*$index*)

Read the ref (key) at the given index. Returns a hashref with the
following keys:

=over

=item key

The key

=item bin_index

The storage bin that contains the value for this key

=item item_index

The index in the bin_index storage bin of the value for this key

=item fragment

HTML fragment that, when applied to the HTML value, points to the
definition of the key.

=back

=item $slob->seek_and_read_storage_bin(*$index*)

Read the storage bin with the given index. Returns the storage bin,
which can later be given to get_entry_of_storage_bin.

=item $slob->get_entry_of_storage_bin(*$bin*, *$index*)

Given a storage bin (as returned by `seek_and_read_storage_bin') and
item index, returns the value at the index i nthe storage bin.

=item $slob->seek_and_read_ref_and_data($index)

Convenience method that returns the key and value at a given index.
Returns a hashref like `seek_and_read_ref' with an extra key,
*data*, which is the value of the key.

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/S*

%changelog
