Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Data/Dump.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Socket-Netlink-Route
Version:        0.05
Release:        alt2_36
Summary:        Interface to Linux's NETLINK_ROUTE netlink socket protocol
# Automatically converted from old format: GPL+ or Artistic - review is highly recommended.
License:        GPL-1.0-or-later OR Artistic-1.0-Perl

URL:            https://metacpan.org/release/Socket-Netlink-Route
Source0:        https://cpan.metacpan.org/authors/id/P/PE/PEVANS/Socket-Netlink-Route-%{version}.tar.gz

BuildArch:      noarch

BuildRequires:  rpm-build-perl
BuildRequires:  perl(ExtUtils/CChecker.pm)
BuildRequires:  perl(ExtUtils/H2PM.pm)
BuildRequires:  perl(Module/Build.pm)
BuildRequires:  perl(Socket/Netlink.pm)
BuildRequires:  perl(Test/More.pm)

Requires:       perl(Socket/Netlink.pm) >= 0.030

## Filter unneeded Provides with RPM 4.8
%{echo 
%filter_from_provides /^perl.Socket.Netlink.Route.pm.$/d
}

## Filter unneeded Provides with RPM 4.9


# For some reason rpmbuild picks this one up as a 'Requires', but not as
# a 'Provides'. Adding it manually or the package fails to install
Provides:       perl(Socket/Netlink/Route_const.pm) == %{version}
Source44: import.info


%description
This module contains the low-level constants and structure handling
functions required to use the NETLINK_ROUTE protocol of Linux's PF_NETLINK
socket family. It is suggested to use the high-level object interface to
this protocol instead; see IO::Socket::Netlink::Route.


%prep
%setup -q -n Socket-Netlink-Route-%{version}


%build
/usr/bin/perl Build.PL installdirs=vendor
./Build


%install
./Build install destdir=%{buildroot} create_packlist=0
find %{buildroot} -depth -type d -exec rmdir {} 2>/dev/null \;

# %{_fixperms} %{buildroot}/*


%check
./Build test


%files
%doc Changes examples LICENSE README
%{perl_vendor_privlib}/IO
%{perl_vendor_privlib}/Socket


%changelog
