%define module_version 1.03
%define module_name Sphinx-Config-Builder
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.03
Release: alt1
Summary: Perl extension dynamically creating Sphinx configuration files 
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/E/ES/ESTRABD/%{module_name}-%{module_version}.tgz
BuildArch: noarch

%description
The motivation behind this module is the need to manage many indexes and corresponding sources
handled by a single Sphinx `searchd' instance.  Managing a configuration file with many indexes
and sources quickly becomes unweildy, and a programatic solution is necessary. Using 
`Sphinx::Config::Builder', one may more easily manage Sphinx configurations using a more
appropriate backend (e.g., a simple `.ini' file or even a  MySQL database). This is particularly
useful if one is frequently adding or deleting indexes and sources. This approach is 
particularly useful for managing non-natively supported Sphinx datasources that might
require the additional step of generating XMLPipe/Pipe2 sources.

This module doesn't read in Sphinx configuration files, it simply allows one
to construct and output a configuration file programmtically.

This module allows one to systematically construct a Sphinx configuration file that
contains so many entries that it is best created dynamically. It's fairly low level,
and provides containers for the following:

=over 4

=item A list of `Sphinx::Config::Entry::Index' objects, one per `index' section;

=item A list of `Sphinx::Config::Entry::Source' objects, one per `source' section;

=item A singular `Sphinx::Config::Entry::Indexer' object, one per configuration for `indexer' options

=item A singular `Sphinx::Config::Entry::Searchd' object, one per configuration for `searchd' options

=back

The general idea is that one builds up a list of `index' sections and corresponding `source' sections. One
then defines the `indexer' and `searchd' options.  One is not bound to specific keywords in each section, meaning
that they may add any key/value pair (as a singleton `HASH' referece). Each key/value pair corresponds to a
key/value line in each section.

All `Sphinx::Config::Entry' derived classes implement a `as_string' method. This method outputs the section
in the format that Sphinx expects. The overall `Sphinx::Config::Builder' class has a `as_string' method
that will iterate over all members, calling their `as_string' method. The result is the full configuration
file that may be printed to STDOUT for the `indexer' to consume using the `--config' option.


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README README.md
%perl_vendor_privlib/S*

%changelog
